
/*
  CLASSiC DAC, Copyright 2013 SILICON CHIP Publications
  Config.h: functions to load configuration file off SD card and set up global config variables
  Written by Nicholas Vinen, 2012-2013
*/

#ifndef _CONFIG_H_
#define _CONFIG_H_

#define CONFIG_FILENAME "DAC.cfg"
#include "sdcard/ff.h"

typedef struct {
  unsigned char Input:3; // 0-7

  unsigned char Mute:1; // boolean
  unsigned char Volume; // 0-255
  signed char Balance:6; //-20 to 20

  unsigned char PlaybackOrder:2; // 0-2

  unsigned char Auto_Play:1; // boolean
  unsigned char Auto_Switch_Enabled:1; // boolean
  unsigned short AutoSwitchDelay:10; // 0-999
  unsigned char AlternativeIRCodes:1; // boolean

  unsigned char Tone_Enabled:1; // boolean
  unsigned char Tone_EqualVolume:1; // boolean
  unsigned char Tone_AutoLoudness:1; // boolean
  signed char Tone_BassBoostCut:6; //-16 to 16
  signed char Tone_TrebleBoostCut:6; //-16 to 16
  unsigned short Tone_BassCrossoverFreq:10; // 50-950
  unsigned short Tone_TrebleCrossoverFreq:14; // 1000-5000

  unsigned char Crossfeed_Enabled:1; // boolean
  unsigned short Crossfeed_LPFFreq:14; // 50-5000
  unsigned char Crossfeed_Delay:5; // 0-31
  unsigned char Crossfeed_Atten:3; // 1-5

  unsigned char StereoSwap:1; // boolean
  unsigned char DownmixToMono:1; // boolean
  unsigned char Filter_Slowrolloff:1; // boolean
  unsigned char InvertPolarity:1; // boolean
  unsigned char NoFreeRunningPLL:1; // boolean
  unsigned char NoDeEmphasis:1; // boolean
  unsigned char Crossfeed_IgnoreHPSocket:1; // boolean
  unsigned char Crossfeed_Disabled:1; // boolean
} DACConfig;

int strncasecmp(const char* s1, const char* s2, unsigned int n);
void reset_config_to_default(DACConfig* pConfig);
unsigned char read_config(FIL* file, DACConfig* pConfig, char* InitFileToHere, int InitFileMaxLen);
unsigned char find_and_read_config(DACConfig* pConfig, char* InitFileToHere, int InitFileMaxLen);

#endif//_CONFIG_H_
